/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.ponder.scene;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmTileEntity;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.items.ItemStackHandler;
import plus.dragons.createcentralkitchen.content.contraptions.blazeStove.BlazeStoveBlock;
import plus.dragons.createcentralkitchen.content.contraptions.blazeStove.BlazeStoveBlockEntity;
import plus.dragons.createcentralkitchen.entry.block.FDBlockEntries;
import plus.dragons.createcentralkitchen.entry.item.FDItemEntries;
import vectorwing.farmersdelight.common.registry.ModItems;

public class BlazeStoveScenes {
    public static void intro(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("blaze_stove.intro", "Create a Blaze Stove");
        scene.configureBasePlate(0, 0, 3);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 2, 1, 2), Direction.DOWN);
        scene.overlay.showText(50).text("To create a Blaze Stove, Right-Click the Blaze Burner with a Cooking Guide in hand when sneaking.").attachKeyFrame().pointAt(util.vector.topOf(1, 1, 1)).placeNearTarget();
        scene.idle(60);
        ItemStack cookingGuide = FDItemEntries.COOKING_GUIDE.asStack();
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(1, 1, 1), Pointing.DOWN).whileSneaking().rightClick().withItem(cookingGuide), 30);
        scene.world.setBlock(util.grid.at(1, 1, 1), FDBlockEntries.BLAZE_STOVE.getDefaultState(), false);
        scene.world.modifyTileEntity(util.grid.at(1, 1, 1), BlazeStoveBlockEntity.class, stove -> stove.setGuide(cookingGuide));
        scene.idle(40);
        scene.overlay.showText(50).text("Cooking Guides are for Cooking Pots, other guides for different kitchenware are also applicable.").attachKeyFrame().pointAt(util.vector.topOf(1, 1, 1)).placeNearTarget();
        scene.idle(60);
        scene.overlay.showText(50).text("To retrieve the Cooking Guide, Right-Click the Blaze Stove with wrench when sneaking.").attachKeyFrame().pointAt(util.vector.topOf(1, 1, 1)).placeNearTarget();
        scene.idle(60);
        scene.world.setBlock(util.grid.at(1, 1, 1), (BlockState)AllBlocks.BLAZE_BURNER.getDefaultState().m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.SMOULDERING), false);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(1, 1, 1), Pointing.DOWN).rightClick().withWrench().whileSneaking(), 30);
        scene.idle(40);
    }

    public static void automation(SceneBuilder scene, SceneBuildingUtil util) {
        ItemStack[] inputItems;
        scene.title("blaze_stove.automation", "Configure the Blaze Stove");
        scene.configureBasePlate(1, 0, 5);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.showBasePlate();
        scene.idle(5);
        BlockPos stovePos = util.grid.at(3, 1, 2);
        Selection stoveSel = util.select.position(stovePos);
        BlockPos potPos = util.grid.at(3, 2, 2);
        Selection stoveAndPotSel = util.select.fromTo(stovePos, potPos);
        scene.world.showSection(stoveAndPotSel, Direction.DOWN);
        scene.idle(10);
        scene.effects.indicateRedstone(stovePos);
        scene.overlay.showSelectionWithText(stoveSel, 70).attachKeyFrame().colored(PonderPalette.RED).text("The Blaze Stove can provide mechanical arm support for kitchenware like Cooking Pot, but it needs to be configured to work.").pointAt(util.vector.centerOf(stovePos)).placeNearTarget();
        scene.idle(80);
        scene.overlay.showText(50).text("Right-Click the Blaze Stove to open the Cooking Guide menu.").attachKeyFrame().pointAt(util.vector.centerOf(stovePos)).placeNearTarget();
        scene.idle(60);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(3, 1, 1), Pointing.DOWN).rightClick(), 30);
        scene.idle(40);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(3, 1, 1), Pointing.LEFT).withItem(((Item)ModItems.GLOW_BERRY_CUSTARD.get()).m_7968_()), 30);
        scene.idle(40);
        scene.overlay.showText(50).text("You may also Right-Click the Blaze Stove with any Guide to swap them.").attachKeyFrame().pointAt(util.vector.centerOf(stovePos)).placeNearTarget();
        scene.idle(60);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(3, 1, 1), Pointing.DOWN).withItem(FDItemEntries.COOKING_GUIDE.asStack()).rightClick(), 30);
        scene.idle(40);
        scene.overlay.showText(50).text("Once you assigned a valid recipe to the Cooking Guide, the Cooking Pot above will become interactive with Mechanical Arms.").attachKeyFrame().pointAt(util.vector.centerOf(stovePos)).placeNearTarget();
        scene.idle(60);
        scene.world.showSection(util.select.position(3, 1, 1), Direction.DOWN);
        scene.idle(10);
        BlockPos rightArmPos = util.grid.at(2, 1, 2);
        Selection rightArmSel = util.select.fromTo(1, 1, 1, 2, 1, 2);
        scene.world.showSection(rightArmSel, Direction.EAST);
        scene.idle(10);
        scene.world.setKineticSpeed(util.select.fromTo(0, 0, 0, 2, 1, 2), 64.0f);
        scene.idle(10);
        AABB basketShape = Shapes.m_83144_().m_83216_(3.0, 1.0, 1.0).m_83215_();
        AABB cookingPotShape = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0).m_83216_(3.0, 2.0, 2.0).m_83215_();
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, new Object(), basketShape, 60);
        scene.idle(10);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, new Object(), cookingPotShape, 60);
        scene.idle(10);
        scene.overlay.showText(180).text("For input, the Mechanical Arm will insert containers and defined ingredients.").attachKeyFrame().pointAt(util.vector.centerOf(rightArmPos)).placeNearTarget();
        for (ItemStack item : inputItems = new ItemStack[]{Items.f_151079_.m_7968_(), ((Item)ModItems.MILK_BOTTLE.get()).m_7968_(), Items.f_42521_.m_7968_(), Items.f_42501_.m_7968_(), Items.f_42590_.m_7968_()}) {
            scene.world.instructArm(rightArmPos, ArmTileEntity.Phase.MOVE_TO_INPUT, ItemStack.f_41583_, 0);
            scene.idle(12);
            scene.world.instructArm(rightArmPos, ArmTileEntity.Phase.SEARCH_OUTPUTS, item, -1);
            scene.idle(8);
            scene.world.instructArm(rightArmPos, ArmTileEntity.Phase.MOVE_TO_OUTPUT, item, 0);
            scene.idle(12);
            scene.world.instructArm(rightArmPos, ArmTileEntity.Phase.SEARCH_INPUTS, ItemStack.f_41583_, -1);
            scene.idle(8);
        }
        BlockPos leftArmPos = util.grid.at(4, 1, 2);
        Selection leftArmSel = util.select.fromTo(4, 1, 1, 5, 1, 2);
        scene.world.showSection(leftArmSel, Direction.WEST);
        scene.idle(10);
        scene.world.setKineticSpeed(util.select.fromTo(4, 0, 0, 6, 1, 2), 64.0f);
        scene.idle(10);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, new Object(), cookingPotShape, 60);
        scene.idle(10);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, new Object(), basketShape, 60);
        scene.idle(10);
        scene.overlay.showText(40).text("For output, the Mechanical Arm will extract result and invalid ingredients.").attachKeyFrame().pointAt(util.vector.centerOf(stovePos)).placeNearTarget();
        ItemStack result = ((Item)ModItems.GLOW_BERRY_CUSTARD.get()).m_7968_();
        scene.world.instructArm(leftArmPos, ArmTileEntity.Phase.MOVE_TO_INPUT, ItemStack.f_41583_, 0);
        scene.idle(12);
        scene.world.instructArm(leftArmPos, ArmTileEntity.Phase.SEARCH_OUTPUTS, result, -1);
        scene.idle(8);
        scene.world.instructArm(leftArmPos, ArmTileEntity.Phase.MOVE_TO_OUTPUT, result, 0);
        scene.idle(12);
        scene.world.instructArm(leftArmPos, ArmTileEntity.Phase.SEARCH_INPUTS, ItemStack.f_41583_, -1);
        scene.idle(18);
    }

    public static void heat_source(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("blaze_stove.heat_source", "Use the Blaze Stove as a Heat Source");
        scene.configureBasePlate(0, 0, 5);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 4, 2, 4), Direction.DOWN);
        BlockPos superBlazePos = util.grid.at(3, 1, 3);
        BlockPos idleBlazePos = util.grid.at(3, 1, 1);
        BlockPos passiveBlazePos = util.grid.at(1, 1, 2);
        scene.overlay.showText(40).text("The Blaze Stove is an active heat source, the hotter the fire, the faster the cooking.").placeNearTarget().pointAt(util.vector.topOf(superBlazePos));
        scene.idle(50);
        scene.overlay.showText(40).text("But cooking can still be done with passive heat.").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(passiveBlazePos));
        scene.idle(50);
        scene.overlay.showText(40).text("Of course, you can also use the Blaze Stove to fry things directly.").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(idleBlazePos));
        scene.idle(10);
        ItemStack[] ingredients = new ItemStack[]{new ItemStack((ItemLike)ModItems.MINCED_BEEF.get()), new ItemStack((ItemLike)ModItems.MINCED_BEEF.get()), new ItemStack((ItemLike)ModItems.MINCED_BEEF.get()), new ItemStack((ItemLike)ModItems.BACON.get()), new ItemStack((ItemLike)ModItems.BACON.get()), new ItemStack((ItemLike)ModItems.BACON.get()), new ItemStack((ItemLike)ModItems.CHICKEN_CUTS.get()), new ItemStack((ItemLike)ModItems.CHICKEN_CUTS.get()), new ItemStack((ItemLike)ModItems.CHICKEN_CUTS.get())};
        int i = 0;
        while (i < 9) {
            int index = i++;
            scene.world.modifyTileEntity(idleBlazePos, BlazeStoveBlockEntity.class, be -> {
                ItemStackHandler inv = be.getInventory();
                inv.insertItem(index, ingredients[index], false);
            });
            scene.idle(4);
        }
        scene.idle(4);
        scene.overlay.showText(40).text("But please note that seething fire can burn your ingredients in an instant.").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(idleBlazePos));
        scene.idle(50);
        scene.world.modifyBlock(idleBlazePos, state -> (BlockState)state.m_61124_(BlazeStoveBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.SEETHING), false);
        scene.world.modifyTileEntity(idleBlazePos, BlazeStoveBlockEntity.class, be -> {
            be.applyCreativeFuel();
            ItemStackHandler inv = be.getInventory();
            for (int i = 0; i < inv.getSlots(); ++i) {
                inv.setStackInSlot(i, ItemStack.f_41583_);
                be.addSmokeAtItem(i, 5);
            }
        });
        scene.idle(20);
    }
}

